/** @file   eric.h
 * @brief   Declaration of Eric - class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:41 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_ERIC_H
#define H_WWW_ERIC_H

#include "npccharacter.h"

namespace WeWantWar {


/** @class  Eric
 * @brief   Yet another guy that helps the player.
 * @author  Tomi Lamminsaari
 *
 */
class Eric : public NpcCharacter
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================


  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	Eric();


	/** Destructor
   */
	virtual ~Eric();

private:

	/** Copy constructor.
   * @param     rO                Reference to another Eric
   */
  Eric( const Eric& rO );

	/** Assignment operator
   * @param     rO                Reference to another Eric
   * @return    Reference to us.
   */
  Eric& operator = ( const Eric& rO );

public:


  ///
  /// Methods
  /// =======

  /** updates this object.
   */
  virtual void update();


  ///
  /// Getter methods
  /// ==============

  /** Returns the type of this object.
   * @return    ObjectID::TYPE_ERIC
   */
  virtual ObjectID::Type objectType() const;
  

protected:

  ///
  /// Members
  /// =======

  eng2d::Vec2D  m_movementVec;
  


private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: eric.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:16:55+02  lamminsa
 * Initial revision
 *
 */
 
